;
;***********************
;  DEMO RELAY & SSRAC  *
;      EXPERIMENT 3    *
;***********************
;
        CPU  "8085.TBL"
        HOF  "INT8"
;

            ORG   2100H

RLSOL:      EQU   0B4H
P_SEG:      EQU   60H
NUM_PORT:   EQU   1
DIPSW:      EQU   0A0H
CTRL:       EQU   0B7H
SYSFAG:     EQU   208CH
DISPY:      EQU   2076H
SCAN:       EQU   2
SYSCAL:     EQU   2
K_DEC:      EQU   11H
K_INC:      EQU   13H
IN2:        EQU   8
;
;***********************
;  INITIAL & CHECK KEY *
;***********************
;
MAIN:   LXI  H,0
        SHLD TEMP_BUF
        SHLD DSPNUM
        SHLD ON_OFF
        MVI  A,8BH
        OUT  CTRL
        MVI  A,0FFH
        OUT  RLSOL
        LDA  SYSFAG
        ORI  00010000B
        STA  SYSFAG
;
MAIN1:  LXI  H,TAB_MAIN
        LXI  D,DISPY
        MVI  B,6
;
MAIN11: MOV  A,M
        STAX D
        INX  H
        INX  D
        DCR  B
        JNZ  MAIN11

        MVI  A,SCAN
        RST  SYSCAL
        CPI  K_DEC
        JZ   OFF
        CPI  K_INC
        JZ   ON
        JMP  MAIN1
;
;/* OFF BIT EXEC */

OFF:    LXI  H,DSPNUM
        MVI  B,71H
        MVI  A,IN2
        RST  SYSCAL
;
        STA  DSPNUM
        ORA  A
        JZ   MAIN1
        MOV  E,A
        CALL OFF_PORT
        JMP  MAIN1
;
;/* ON BIT EXEC */

ON:     LXI  H,DSPNUM+1
        MVI  B,5CH
        MVI  A,IN2
        RST  SYSCAL
;
        STA  DSPNUM+1
        ORA  A
        JZ   MAIN1
        MOV  E,A
        CALL ON_PORT
        JMP  MAIN1
;
;***********************
;    ON PORT BIT SUB.  *
;***********************

ON_PORT:
        MVI  A,00000000B
        MVI  C,10000000B
        CALL GET_ONOFF
        LXI  H,ON_OFF
        LXI  D,TEMP_BUF
        MVI  B,NUM_PORT
;
ON_P1:  LDAX D
        ORA  M
        MOV  M,A
        INX  H
        INX  D
        DCR  B
        JNZ  ON_P1
        CALL OUT_PORT
        RET
;
;***********************
;   OFF PORT BIT SUB.  *
;***********************

OFF_PORT:
        MVI  A,11111111B
        MVI  C,01111111B
        CALL GET_ONOFF

        LXI  H,ON_OFF
        LXI  D,TEMP_BUF
        MVI  B,NUM_PORT
;
OFF_P13:
        LDAX D
        ANA  M
        MOV  M,A
        INX  H
        INX  D
        DCR  B
        JNZ  OFF_PORT
        CALL OUT_PORT
        RET
;
;***********************
;  SUB FOR GET ON-OFF  *
;***********************

GET_ONOFF:
        LXI  H,TEMP_BUF
        MVI  B,NUM_PORT
GET_ONF:
        MOV  M,A
        INX  H
        DCR  B
        JNZ  GET_ONF
;
GET_ONF1:
        LXI  H,TEMP_BUF
        MOV  A,C
        RAL
        MVI  B,NUM_PORT
;
GET_ONF2:
        MOV  A,M
        RAL
        MOV  M,A
        INX  H
        DCR  B
        JNZ  GET_ONF2
        RAR
        MOV  C,A
        MOV  A,E
        SUI  1
        CALL SUB_DAA
        MOV  E,A
        ORA  A
        JNZ  GET_ONF1
        RET
;
;***********************
;    SEND REAL DATA    *
;***********************

OUT_PORT:
        LXI  H,ON_OFF
        MOV  A,M
        CMA
        OUT  RLSOL
        RET
;
;
;***********************
;        SUB-DAA       *
;***********************
;
SUB_DAA: PUSH B
         MOV  B,A
         ANI  0FH
         CPI  0AH
         MOV  A,B
         JC   SUB_D1
         SBI  6
SUB_D1:  MOV  B,A
         ANI  0F0H
         CPI  0A0H
         MOV  A,B
         JC   SUB_D2
         SBI  60H
SUB_D2:  POP  B
         RET
;

;/*  DATA TABLE OF DISPLAY & COMMAND */

TAB_MAIN:  DFB  5CH,54H,40H,5CH,71H,71H

;
;/*  RAM WORKING AREA FOR BUFFER & REAL DATA */

           ORG  3000H
TEMP_BUF:  DFS   NUM_PORT         ;buffer to temporary
ON_OFF:    DFS   NUM_PORT         ;buffer real data
DSPNUM:    DFS   2
           END




